IF  EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[dbo].[P_GERA_RESSUPRIMENTO_POOL]') AND type in (N'P', N'PC'))
	DROP PROCEDURE [dbo].[P_GERA_RESSUPRIMENTO_POOL]
GO


CREATE PROCEDURE [dbo].[P_GERA_RESSUPRIMENTO_POOL] (@CD_EMP INT =1)
as
SET NOCOUNT ON; 

DECLARE 
	@DIAS_RES_ACRESCENTAR INT=0, 
	@DIA_SEMANA		INT= 0,
	@HOJE			DATE,
	@CD_CTR			int;
	
/************************************************************************************************************/
	SET @DIAS_RES_ACRESCENTAR=ISNULL((SELECT DIAS_RES_ACRESCENTAR FROM PRC_EMP WHERE CD_EMP = @CD_EMP),0);
	SELECT	@HOJE = CONVERT(CHAR(10),GETDATE() + @DIAS_RES_ACRESCENTAR,120),
			@DIA_SEMANA = DATEPART(weekday,@HOJE);
							
	
  	IF  OBJECT_ID('TEMPDB.DBO.#TMP_COMPRA_POR_SUPRIMENTO') IS NOT NULL
	BEGIN
		 DROP TABLE #TMP_COMPRA_POR_SUPRIMENTO
	END 
	CREATE TABLE #TMP_COMPRA_POR_SUPRIMENTO (ID TINYINT);

	INSERT INTO #TMP_COMPRA_POR_SUPRIMENTO 
	SELECT 0 id
	union all 
	SELECT 2 --Sup/Ressup
 	  
/****************************************************************************************/
	DELETE FROM EST_PROD_TRANSF_GERAL
		WHERE DT_TRANSF=@HOJE AND STS_TRANSF=0;		
/****************************************************************************************/
	DECLARE @CD_FIL_RES  AS INT
	DECLARE ljs CURSOR 
		FAST_FORWARD FOR 
		SELECT 
			CD_FILIAL 
		FROM 
			PRC_FILIAL 
		WHERE 
			STS_FILIAL=0
			AND NOT CD_FILIAL IN (SELECT CD_FILIAL FROM PRC_FILIAL_DEPOSITO)
			
	OPEN ljs
	FETCH NEXT FROM ljs INTO @CD_FIL_RES

	WHILE @@FETCH_STATUS=0
		BEGIN
			print 'Insere dados da filial ' + convert(varchar, @CD_FIL_RES) + ' EST_PROD_TRANSF_GERAL_CPL - Time: ' + convert(varchar, getdate(),108)	
			
			INSERT INTO GLB_EXEC_LOG_ROTINAS (DT_LOG,DT_HR_LOG,MSG_LOG,OPERADOR,LINHA,ROTINA,ROTINA_AUX,PROCESSO)	
				VALUES (GETDATE(),GETDATE(), 'Insere dados da filial ' + convert(varchar, @CD_FIL_RES) ,'INSERT',56,'P_GERA_RESSUPRIMENTO_POOL','EST_PROD_TRANSF_GERAL','RESSUPRIMENTO')

			INSERT INTO EST_PROD_TRANSF_GERAL (CD_EMP,CD_FIL_DEST,DT_TRANSF,DT_ENTR,STS_TRANSF,DT_CAD)
			SELECT
				@CD_EMP,@CD_FIL_RES,@HOJE,@HOJE,0,GETDATE()


			SET @CD_CTR = IDENT_CURRENT('EST_PROD_TRANSF_GERAL')  
			
			INSERT INTO EST_PROD_TRANSF_GERAL_CPL (CD_CTR,CD_EMP,CD_PROD,CD_SIGLA,CD_ARV_MERC_LINHA, QT_UNI_RESSUPRIMENTO,QT_NECESSIDADE,QT_AT,
													QT_EST,QT_PEND,QT_EMAX,QT_ESEG,EMAX,ESEG,MEDIAF,PARAM_ESPECIAL,FDIAS, FLAG_RESSUPRIMENTO_CAIXA_FECHADA)
			SELECT distinct																			
				@CD_CTR,
				p.CD_EMP, 
				p.CD_PROD,
				cpl.CD_SIGLA,
				Arv.CD_ARV_MERC_LINHA,
				case when ISNULL(P.QT_UNI_RESSUPRIMENTO,0) < 1 then 
					1 else ISNULL(P.QT_UNI_RESSUPRIMENTO,0) end   QT_UNI_RESSUPRIMENTO,
				0 QT_NECESSIDADE,	
				0 QT_AT,
				CPL.QT_EST,
				cpl.QT_EST_PEND,
				isnull(dbo.UFD_EST_AJUSTA_EMAX(cpl.QTDE_FACEAMENTO , getdate(), 
											cpl.QTDE_FINANCIADO  , cpl.QTDE_LIMITADOR , 
												ROUND(arvmerc.MEDIAF/30.0000 * (
																				--sem par?metro especial nem aumento, retorna valores originais da ?rvore mercadol?gica		
																				CASE WHEN coalesce(pespSem.CD_GRP_PARAM, pespSemNovo.CD_EMP, 0) = 0 THEN
																					ROUND(arvmerc.EMAX * (1 + ISNULL(pesp.EMAX/100, 0) + ISNULL(aument.PERC_AUMENTO/100, 0)), 0)
																				ELSE
																					ROUND( coalesce(pespSem.EMAX,pespSemNovo.EMAX ) * (1 + ISNULL(pesp.EMAX/100, 0) + ISNULL(aument.PERC_AUMENTO/100, 0)), 0)
																				END), 2)),0) QT_EMAX ,
												
				isnull(dbo.UFD_EST_AJUSTA_ESEG(  cpl.QTDE_FACEAMENTO  , 
											getdate(), 
											cpl.QTDE_FINANCIADO , 
											ROUND(arvmerc.MEDIAF/30 * (CASE WHEN coalesce(pespSem.CD_GRP_PARAM, pespSemNovo.CD_EMP, 0) = 0 THEN
					ROUND(arvmerc.Eseg * (1 + ISNULL(pesp.ESEG/100, 0) + ISNULL(aument.PERC_AUMENTO/100, 0)), 0)
				ELSE
					ROUND(coalesce(pespSem.ESEG,pespSemNovo.ESEG)  * (1 + ISNULL(pesp.ESEG/100, 0) + ISNULL(aument.PERC_AUMENTO/100, 0)), 0)
				END), 2) ),0) QT_ESEG , 

				isnull(CASE WHEN coalesce(pespSem.CD_GRP_PARAM, pespSemNovo.CD_EMP, 0) = 0 THEN
					ROUND(arvmerc.EMAX * (1 + ISNULL(pesp.EMAX/100, 0) + ISNULL(aument.PERC_AUMENTO/100, 0)), 0)
				ELSE
					ROUND( coalesce(pespSem.EMAX,pespSemNovo.EMAX ) * (1 + ISNULL(pesp.EMAX/100, 0) + ISNULL(aument.PERC_AUMENTO/100, 0)), 0)
				END,0) EMAX,

				isnull(CASE WHEN coalesce(pespSem.CD_GRP_PARAM, pespSemNovo.CD_EMP, 0) = 0 THEN
					ROUND(arvmerc.Eseg * (1 + ISNULL(pesp.ESEG/100, 0) + ISNULL(aument.PERC_AUMENTO/100, 0)), 0)
				ELSE
					ROUND(coalesce(pespSem.ESEG,pespSemNovo.ESEG)  * (1 + ISNULL(pesp.ESEG/100, 0) + ISNULL(aument.PERC_AUMENTO/100, 0)), 0)
				END,0) ESEG,	
				isnull(arvmerc.MEDIAF,0),
				PARAM_ESPECIAL = CASE WHEN pesp.CD_GRP_PARAM IS NULL THEN 0 ELSE 1 END,
				FDIAS = ISNULL(pesp.FDIAS, 0) ,
				p.FLAG_RESSUPRIMENTO_CAIXA_FECHADA
 			FROM
				EST_PROD p  

				JOIN  V_EST_PROD_CPL_ESTOQUE   cpl ON  
					p.CD_EMP			= cpl.CD_EMP	   AND 
					p.CD_PROD			= cpl.CD_PROD

				JOIN EST_PROD_EST_ARV_MERCADOLOGICA Arv  ON 
					p.CD_EMP  = Arv.CD_EMP AND
					p.CD_PROD = Arv.CD_PROD
					 
				INNER JOIN V_EST_ARV_GRP_RESSUPRIMENTO grp ON
					cpl.CD_EMP			   = grp.CD_EMP AND 
					cpl.CD_FILIAL		   = grp.CD_FILIAL AND 
					Arv.CD_ARV_MERC_LINHA  = grp.CD_ARV_MERC_LINHA  

				LEFT JOIN V_EST_PROD_EST_ARV_MERCADOLOGICA	arvmerc on 
				cpl.CD_EMP			= arvmerc.CD_EMP	   AND 
				cpl.CD_FILIAL		= arvmerc.CD_FILIAL	   AND 
				cpl.CD_PROD			= arvmerc.CD_PROD

				LEFT JOIN EST_ARV_MD_F_GRP_PARAM_ESPECIAIS_DIA_SEMANA pespSem	ON
					arvmerc.CD_EMP			= pespSem.CD_EMP AND 
					arvmerc.CD_GRP_PARAM	= pespSem.CD_GRP_PARAM AND
					pespSem.DIA_SEMANA		= DATEPART(WEEKDAY,@HOJE) AND
					pespSem.FLAG_APLICACAO IN (0,1)			
				 
				LEFT JOIN EST_PARAM_COMPRAS_GRUPO_ESPECIAIS_DIA_SEMANA pespSemNovo	ON
					arvmerc.CD_EMP			= pespSemNovo.CD_EMP	AND 
					arvmerc.CD_FILIAL		= pespSemNovo.CD_FILIAL AND 
					arvmerc.CD_SIGLA			= pespSemNovo.CD_SIGLA	AND 
					arvmerc.CD_GRP_PARAM		= pespSemNovo.CD_CTR AND 
					arvmerc.CD_ARV_MERC_LINHA	= pespSemNovo.CD_ARV_MERC_LINHA  AND
					pespSemNovo.DIA_SEMANA		= DATEPART(WEEKDAY,@HOJE) AND
					pespSemNovo.FLAG_APLICACAO IN (0,1)		 

				LEFT JOIN EST_ARV_MD_F_GRP_PARAM_ESPECIAIS pesp	ON
					pesp.CD_EMP			= arvmerc.CD_EMP AND 
					pesp.CD_GRP_PARAM	= arvmerc.CD_GRP_PARAM AND 
					(pesp.FDIAS_ULT_ATU IS NULL 
							OR DATEADD(DAY, pesp.FDIAS, pesp.FDIAS_ULT_ATU) <= @HOJE AND pesp.DT_INICIAL<=@HOJE)
				
				LEFT JOIN EST_ARV_GRP_RESSUPRIMENTO_PERC_AUMENTO aument ON --aumento de percentual do Emax e Eseg por data
					aument.CD_EMP			= cpl.CD_EMP AND 
					aument.CD_SIGLA			= cpl.CD_SIGLA AND 
					aument.DT_RESSUP		= @HOJE 

				--- AS FILIAIS POR LINHA QUE NAO RODAM HOJE
				LEFT JOIN EST_ARV_GRP_RESSUPRIMENTO_NAO_EXECUTAR_DIA_SEMANA_PRC_FILIAL_LINHA N_LJ_LINHA ON
					GRP.CD_EMP					= N_LJ_LINHA.CD_EMP AND
					GRP.CD_FILIAL				= N_LJ_LINHA.CD_FILIAL AND
					GRP.CD_ARV_MERC_LINHA		= N_LJ_LINHA.CD_ARV_MERC_LINHA  AND 
					N_LJ_LINHA.DIA_SEMANA		= @DIA_SEMANA

				LEFT JOIN EST_ARV_GRP_RESSUPRIMENTO_NAO_EXECUTAR_LINHA_DIA_SEMANA N_L ON
					GRP.CD_EMP					= N_L.CD_EMP AND 
					GRP.CD_ARV_MERC_LINHA		= N_L.CD_ARV_MERC_LINHA  AND 
					N_L.DIA_SEMANA				= @DIA_SEMANA

				LEFT JOIN EST_ARV_GRP_RESSUPRIMENTO_NAO_EXECUTAR_FABRIC_DIA_SEMANA N_F ON
					P.CD_EMP					= N_F.CD_EMP AND 
					P.CD_FABRIC					= N_F.CD_FABRIC  AND 
					N_F.DIA_SEMANA				= @DIA_SEMANA

				LEFT JOIN EST_ARV_GRP_RESSUPRIMENTO_NAO_EXECUTAR_DIA_SEMANA_PRC_FILIAL N_S_LJ ON
					grp.CD_EMP					= N_S_LJ.CD_EMP AND 
					grp.CD_FILIAL				= N_S_LJ.CD_FILIAL  AND 
					N_S_LJ.DIA_SEMANA			= @DIA_SEMANA 

				LEFT JOIN EST_ARV_GRP_RESSUPRIMENTO_NAO_EXECUTAR_FILIAL N_DT_LJ ON
					grp.CD_EMP					= N_DT_LJ.CD_EMP AND 
					grp.CD_FILIAL				= N_DT_LJ.CD_FILIAL  AND 
					N_DT_LJ.DT_NAO_RESSUP		=@HOJE

				LEFT JOIN EST_ARV_GRP_RESSUPRIMENTO_NAO_EXECUTAR N_GRP ON
					grp.CD_EMP					= N_GRP.CD_EMP AND 
					grp.CD_GRP_RES				= N_GRP.CD_GRP_RES  AND 
					N_GRP.DT_NAO_RESSUP			= @HOJE
					 
		   
			WHERE 
				p.CD_EMP = @CD_EMP
				--AND P.STS_PROD IN (0,2) Sol. Isaias
				AND P.STS_PROD =0
				-- RETIRA OS PRODUTOS BLOQUEADOS OU INATIVOS
				AND grp.CD_FILIAL		= cpl.CD_FILIAL
				AND cpl.STS_PROD_FILIAL  = 0 
				 
				AND N_LJ_LINHA.CD_EMP IS NULL  -- AS FILIAIS POR LINHA QUE NAO RODAM HOJE
				AND N_L.CD_EMP		  IS NULL  -- AS LINHAS QUE NAO RODAM HOJE
				AND N_F.CD_EMP		  IS NULL  -- OS FABRICANTES QUE NAO RODAM HOJE			 
				AND N_S_LJ.CD_EMP 	  IS NULL  -- AS FILIAIS QUE NAO RODAM HOJE 
				AND N_DT_LJ.CD_EMP	  IS NULL  -- AS FILIAIS QUE NAO RODAM HOJE POR DATA 
				AND N_GRP.CD_EMP	  IS NULL  -- OS GRUPOS QUE NAO RODAM HOJE POR DATA  
				AND  grp.CD_FILIAL=@CD_FIL_RES 
				
				--SE FOR DEPOSITO AUXILIAR, MANDA SOMENTE OS PRODUTOS CUJO TIPO DE COMPRA SEJA RESSUP OU SUP-RESSUP
				AND COALESCE(cpl.COMPRA_POR_SUPRIMENTO, p.COMPRA_POR_SUPRIMENTO, 0) 
						IN (SELECT ID FROM #TMP_COMPRA_POR_SUPRIMENTO);
						 
			UPDATE EST_PROD_TRANSF_GERAL_CPL 
				SET QT_NECESSIDADE = ROUND(QT_EMAX,0) - ROUND(QT_PEND,0)
				WHERE CD_CTR=@CD_CTR;
			
			--Habilitar depois	
			--DELETE FROM EST_PROD_TRANSF_GERAL_CPL WHERE	SALDO <=0 AND CD_CTR=@CD_CTR;

			FETCH NEXT FROM ljs INTO @CD_FIL_RES

		END
		
	CLOSE ljs
	DEALLOCATE ljs 